#include <stddef.h>

/*@ logic integer occ(int v, int* array, integer b, integer e) =
      b >= e ? 0 : (integer)(array[e-1] == v) + occ(v, array, b, e-1) ;
*/

/*@ ghost
    /@ requires \valid_read(&arr[0 .. len-1]);
       decreases len ;
       assigns  \nothing ;
       ensures  0 <= occ(v, arr, 0, len) <= len ;
    @/
    void occ_bounds(int v, int* arr, size_t len){
      if(len > 0) occ_bounds(v, arr, len-1);
    }

    /@ requires \valid_read(&arr[0 .. more-1]);
       requires pos <= more ;
       decreases more;
       assigns \nothing ;
       ensures occ(v, arr, 0, pos) <= occ(v, arr, 0, more);
    @/
    void occ_monotonic(int v, int* arr, size_t pos, size_t more){
      if(more > pos) occ_monotonic(v, arr, pos, more-1);
      // else { /@ assert more == pos ; @/ }
    }

    /@ requires \valid_read(&arr[0 .. len-1]);
       requires occ(v, arr, 0, len) == 0 ;
       decreases len;
       assigns \nothing ;
       ensures \forall integer i ; 0 <= i < len ==> arr[i] != v ;
    @/ 
    void occ_0_implies_not_in(int v, int* arr, size_t len){
       if(len > 0){
         occ_bounds(v, arr, len-1);
	 //-> occ(v, arr, len-1) >= 0
         occ_monotonic(v, arr, len-1, len);
	 //-> occ(v, arr, len-1) <= occ(v, arr, len)
	 //-> occ(v, arr, len-1) <= 0 
         occ_0_implies_not_in(v, arr, len-1);
       }
    }

    /@ requires \valid_read(&arr[0 .. len-1]);
       requires occ(v, arr, 0, len) > 0 ;
       decreases len;
       assigns \nothing ;
       ensures 0 <= \result < len && arr[\result] == v ;
    @/
    size_t occ_pos_implies_in(int v, int* arr, size_t len){
      if(len > 0){
        if(arr[len-1] == v) return len-1;
	return occ_pos_implies_in(v, arr, len-1);
      }
      // occ_bounds(v, arr, len);
      /@ assert \false ; @/
    }

    /@ requires \valid_read(&arr[0 .. len-1]);
       requires occ(v, arr, 0, len) > 0 ;
       decreases len;
       assigns \nothing ;
       ensures \exists integer i ; 0 <= i < len && arr[i] == v ;
    @/
    void occ_pos_implies_exists(int v, int* arr, size_t len){
      size_t r = occ_pos_implies_in(v, arr, len);
    }
*/

//@ requires \valid(&b[0 .. len-1]);
void foo(int* b, size_t len){
  int a[1] = {3};
  //@ assert occ((int)3, &a[0], 0, 1) == 1;
  //@ assert occ((int)4, &a[0], 0, 1) == 0;

  //@ ghost occ_bounds(3, b, len);
  //@ assert occ((int)3, b, 0, len) <= len ;
}
