#include <stddef.h>

/*@ predicate unchanged{L1, L2}(int* a, integer fst, integer last) =
      \forall integer j;
        fst <= j < last ==> \at(a[j], L1) == \at(a[j], L2);

    predicate replaced{L1, L2}(int* a, integer len, int old, int new) =
      (\forall integer j;
         0 <= j < len && \at(a[j], L1) == old ==>
           \at(a[j], L2) == new) &&
      (\forall integer j;
         0 <= j < len && \at(a[j], L1) != old ==>
           \at(a[j], L2) == \at(a[j], L1));
*/

/*@ requires \valid(arr + (0 .. len-1));
    assigns arr[0 .. len-1];
    ensures replaced{Pre, Here}(arr, len, old, new) ;
*/
void search_and_replace(int* arr, size_t len, int old, int new){
  /*@ loop invariant 0 <= i <= len;
      loop invariant unchanged{Pre, Here}(arr, i, len) ;
      loop invariant replaced{Pre, Here}(arr, i, old, new) ;
      loop assigns i, arr[0 .. len-1];
      loop variant len-i; */
  for(size_t i = 0; i < len; ++i)
    if(arr[i] == old) arr[i] = new;
}
